varying vec2 TexCoord;				//current texcoord
uniform sampler2D src;				// texture to sample

uniform float	texwidth;			//texture_width
uniform float	kernel[9];			// kernel
uniform float	kernel_norm;		// kernel normalisation
uniform float	postprocess2d_amount; //amount of filter to add in

void main()
{
	float stepsize	= 1.0/texwidth;
	
	//image color
	vec4 originalcolor = texture2D(src,TexCoord);
	
	//apply our kernel
	vec4 finalcolor;
	finalcolor	= texture2D(src,TexCoord+vec2(-stepsize,stepsize))  * kernel[0];
	finalcolor	+= texture2D(src,TexCoord+vec2(0, stepsize))  * kernel[1];
	finalcolor	+= texture2D(src,TexCoord+vec2(stepsize, stepsize))  * kernel[2];
	finalcolor	+= texture2D(src,TexCoord+vec2(-stepsize,0))  * kernel[3];
	finalcolor	+= texture2D(src,TexCoord)* kernel[4];
	finalcolor	+= texture2D(src,TexCoord+vec2(stepsize,0))   * kernel[5];
	finalcolor	+= texture2D(src,TexCoord+vec2(-stepsize,-stepsize)) * kernel[6];
	finalcolor	+= texture2D(src,TexCoord+vec2(0,-stepsize))  * kernel[7];
	finalcolor	+= texture2D(src,TexCoord+vec2(stepsize,-stepsize))  * kernel[8];
	finalcolor /= kernel_norm;

	//mask
	vec4 maskcolor = originalcolor-finalcolor;
	
	vec4 mask = postprocess2d_amount*maskcolor;

	//add them 
	finalcolor = originalcolor+mask;

	//set alpha to 1.0
	finalcolor.w = 1.0;
	
	gl_FragColor = finalcolor;
}